/**
 * Copyright Notice
 *
 * This is a work of the U.S. Government and is not subject to copyright
 * protection in the United States. Foreign copyrights may apply.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package gov.va.med.term.mvx.reader;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import gov.va.med.term.mvx.data.MVXCodes;
import gov.va.med.term.mvx.data.ObjectFactory;
import gov.va.oia.terminology.converters.sharedUtils.ConsoleUtil;

/**
 * 
 * {@link MVXReader}
 *
 * @author <a href="mailto:joel.kniaz.list@gmail.com">Joel Kniaz</a>
 *
 */
public class MVXReader {
	private final File file_;

	/**
	 * 
	 */
	public MVXReader(File inputFileOrDirectory) {
		if (inputFileOrDirectory.isDirectory())
		{
			ArrayList<File> files = new ArrayList<File>();
			for (File f : inputFileOrDirectory.listFiles())
			{
				if (f.isFile()
						&& (f.getName().toLowerCase().endsWith(".xml")))
				{
					files.add(f);
				}
			}
			
			if (files.size() != 1)
			{
				throw new RuntimeException(files.size() + " xml files were found inside of " + inputFileOrDirectory.getAbsolutePath() 
						+ " but this implementation requires 1 and only 1 xml file to be present.");
			}
			
			file_ = files.get(0);
		}
		else
		{
			file_ = inputFileOrDirectory;
		}

		ConsoleUtil.println("Prepared to process: " + file_.getAbsolutePath());
	}

	public MVXCodes process() throws IOException, JAXBException {
		byte[] data = Files.readAllBytes(file_.toPath());
		ByteArrayInputStream xmlContentBytes = new ByteArrayInputStream (data);
		//XMLStreamReader xmlStreamReader = new DomStreamReader(file_);
		JAXBContext context = JAXBContext.newInstance(ObjectFactory.class);
		Unmarshaller unmarshaller = context.createUnmarshaller();
		//note: setting schema to null will turn validator off
		unmarshaller.setSchema(null);
		Object xmlObject = MVXCodes.class.cast(unmarshaller.unmarshal(xmlContentBytes));
		return (MVXCodes)xmlObject;
	}
}
